<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Frontend Routes
$routes->get('/', 'Products::index');           // Homepage → products
$routes->get('products', 'Products::products');
$routes->get('about', 'About::index');    
$routes->get('product/(:segment)', 'Products::detail/$1'); // Product details

$routes->get('blogs', 'Blog::index'); // List page
$routes->get('blog/(:segment)', 'Blog::detail/$1'); // Blog detail page with slug
$routes->get('media', 'Media::index');
$routes->get('contact-us', 'Contact::index');
$routes->post('/contact/send', 'Contact::send');



// Admin Routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    
    $routes->get('product/deleteGalleryImage/(:num)/(:any)', 'Admin\Product::deleteGalleryImage/$1/$2');

    
    
    // Protected routes
    $routes->get('dashboard', 'Admin\Dashboard::index');
    $routes->get('product', 'Admin\Product::index');
    $routes->get('product/create', 'Admin\Product::create');
    $routes->post('product/store', 'Admin\Product::store');
    $routes->get('product/edit/(:num)', 'Admin\Product::edit/$1');
    $routes->post('product/update/(:num)', 'Admin\Product::update/$1');
    $routes->get('product/delete/(:num)', 'Admin\Product::delete/$1');
    
    $routes->get('about', 'Admin\About::index');
    $routes->get('about/create', 'Admin\About::create');
    $routes->post('about/store', 'Admin\About::store');
    $routes->get('about/edit/(:num)', 'Admin\About::edit/$1');
    $routes->post('about/update/(:num)', 'Admin\About::update/$1');
    $routes->get('about/delete/(:num)', 'Admin\About::delete/$1');
    
     $routes->get('media', 'Admin\Media::index');
    $routes->get('media/create', 'Admin\Media::create');
    $routes->post('media/store', 'Admin\Media::store');
    $routes->get('media/delete/(:num)', 'Admin\Media::delete/$1');
    
    $routes->get('blog', 'Admin\Blog::index');
    $routes->get('blog/create', 'Admin\Blog::create');
    $routes->post('blog/store', 'Admin\Blog::store');
    $routes->get('blog/edit/(:num)', 'Admin\Blog::edit/$1');
    $routes->post('blog/update/(:num)', 'Admin\Blog::update/$1');
    $routes->get('blog/delete/(:num)', 'Admin\Blog::delete/$1');
    
    $routes->get('banner', 'Admin\Banner::index');
    $routes->get('banner/create', 'Admin\Banner::create');
    $routes->post('banner/store', 'Admin\Banner::store');
    $routes->get('banner/edit/(:num)', 'Admin\Banner::edit/$1');
    $routes->post('banner/update/(:num)', 'Admin\Banner::update/$1');
    $routes->get('banner/delete/(:num)', 'Admin\Banner::delete/$1');

    // Change password page
    $routes->get('change-password', 'Admin\Login::changePassword', ['filter' => 'auth']);
    $routes->post('change-password/update', 'Admin\Login::updatePassword', ['filter' => 'auth']);
    
    


});

// Exclude login routes from filter
$routes->get('admin', 'Admin\Login::index');
$routes->get('admin/login', 'Admin\Login::index');
$routes->post('admin/login/auth', 'Admin\Login::auth');

$routes->get('admin/logout', 'Admin\Login::logout');






