<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ProductModel;

class Product extends BaseController
{
    public function index()
    {
        $model = new ProductModel();
        $data['products'] = $model->findAll();
        return view('admin/products/index', $data);
    }

    public function create()
    {
        return view('admin/products/create');
    }

    public function store()
    {
        $model = new ProductModel();

        // ---- Single thumbnail ----
        $imageName = null;
        $thumbnail = $this->request->getFile('image');
        if ($thumbnail && $thumbnail->isValid() && !$thumbnail->hasMoved()) {
            $imageName = $thumbnail->getRandomName();
            $thumbnail->move('uploads/products', $imageName);
        }

        // ---- Multiple images ----
        $uploadedImages = [];
        $images = $this->request->getFileMultiple('images');
        if ($images) {
            foreach ($images as $img) {
                if ($img->isValid() && !$img->hasMoved()) {
                    $multiImageName = $img->getRandomName();
                    $img->move('uploads/products', $multiImageName);
                    $uploadedImages[] = $multiImageName;
                }
            }
        }
        $imagesString = !empty($uploadedImages) ? implode(',', $uploadedImages) : null;

        // ---- Insert data ----
        $model->insert([
            'name'        => $this->request->getPost('name'),
            'description' => $this->request->getPost('description'),
            'price'       => $this->request->getPost('price'),
            'image'       => $imageName,
            'images'      => $imagesString,
            'slug'        => $this->request->getPost('slug')
        ]);

        return redirect()->to(base_url('admin/product'))->with('success', 'Product added successfully!');
    }

    public function edit($id)
    {
        $model = new ProductModel();
        $data['product'] = $model->find($id);

        // Convert images string to array
        $data['images'] = [];
        if (!empty($data['product']['images'])) {
            $data['images'] = explode(',', $data['product']['images']);
        }

        return view('admin/products/edit', $data);
    }

    public function update($id)
{
    $model = new ProductModel();
    $product = $model->find($id);

    // Single Image Update
    $imageName = $product['image'];
    $img = $this->request->getFile('image');

    if ($img && $img->isValid() && !$img->hasMoved()) {
        if ($imageName && file_exists('uploads/products/' . $imageName)) {
            unlink('uploads/products/' . $imageName);
        }

        $imageName = $img->getRandomName();
        $img->move('uploads/products', $imageName);
    }

    // Multiple Images Update
    $existingImages = !empty($product['images']) ? explode(',', $product['images']) : [];
    $newImages = $this->request->getFileMultiple('images');

    if (!empty($newImages)) {
        foreach ($newImages as $mimg) {
            if ($mimg->isValid() && !$mimg->hasMoved()) {
                $multiImageName = $mimg->getRandomName();
                $mimg->move('uploads/products', $multiImageName);
                $existingImages[] = $multiImageName;
            }
        }
    }

    $imagesString = !empty($existingImages) ? implode(',', $existingImages) : null;

    $model->update($id, [
        'name'        => $this->request->getPost('name'),
        'description' => $this->request->getPost('description'),
        'price'       => $this->request->getPost('price'),
        'image'       => $imageName,
        'images'      => $imagesString,
        'slug'        => $this->request->getPost('slug')
    ]);

    return redirect()->to(base_url('admin/product'))->with('success', 'Product updated successfully!');
}



    public function delete($id)
    {
        $model = new ProductModel();
        $product = $model->find($id);

        // Delete single thumbnail
        if ($product && $product['image'] && file_exists('uploads/products/' . $product['image'])) {
            unlink('uploads/products/' . $product['image']);
        }

        // Delete multiple images
        if (!empty($product['images'])) {
            $multiImages = explode(',', $product['images']);
            foreach ($multiImages as $img) {
                if (file_exists('uploads/products/' . $img)) {
                    unlink('uploads/products/' . $img);
                }
            }
        }

        $model->delete($id);
        return redirect()->to(base_url('admin/product'))->with('success', 'Product deleted successfully!');
    }
    
    public function deleteGalleryImage($productId, $imageName)
{
    $imageName = urldecode($imageName);

    $model = new ProductModel();
    $product = $model->find($productId);

    if (!empty($product['images'])) {
        $images = explode(',', $product['images']);

        if (($key = array_search($imageName, $images)) !== false) {
            unset($images[$key]);
        }

        if (file_exists('uploads/products/'.$imageName)) {
            unlink('uploads/products/'.$imageName);
        }

        $model->update($productId, ['images' => implode(',', $images)]);
    }

    return redirect()->to(base_url('admin/product/edit/'.$productId))->with('success', 'Image deleted successfully!');
}


}
